#!/bin/bash

echo 'HIBERNATE_MODE=reboot' > /etc/pm/config.d/hibernate.conf

# FIXME: do this RAM size dependend ?
SIZES=(50M 75M 100M 125M 150M 175M 200M)
NS=${#SIZES[*]}

NP=5
declare -A pids

function kill_wait()
{
	for ((i=0; i < $NP; i++)) ; do
		kill ${pids[$i]}
	done
	for ((i=0; i < $NP; i++)) ; do
		wait ${pids[$i]}	
	done
}

function exit_script()
{
	kill_wait
	exit 0
}
trap exit_script INT TERM EXIT

n=0
while true; do
	k=`expr $n % $NS`
	for ((i=0; i < $NP; i++)) ; do
		./checkmem ${SIZES[$k]} &
		pids[$i]=$!
	done

	sleep 10

	echo "Start hibernate $n"
	pm-hibernate
	echo "Resume hibernate $n"
 
	if dmesg | grep -q Slab ; then
		echo "Corruption in slab after $n iterations!"
		while true ; do
			sleep 100;
		done
	fi

	sleep 10

	kill_wait
	
	let n++
	sleep 10
done 
