#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>

unsigned int pattern;
unsigned int *ptr;
int finish = 0;
int size;

void initArgs(int argc, char *argv[])
{
	int rc;
	char suf;

	if (argc != 2)
		goto exit;

	rc = sscanf(argv[1], "%d%c", &size, &suf);
	if (rc == 1)
		return;
	else if(rc == 2) {
		switch (suf) {
		case 'M':
		case 'm':
			size *= 1024 * 1024;
			return;
		case 'K':
		case 'k':
			size *= 1024;
			return;
		default:
			goto exit;
		}
	}

exit:		
	fprintf(stderr, "usage: %s size\n", argv[0]);
	exit(1);
}

void initPattern()
{ 
	struct timeval tv = { 0xdeadbeaf, 0 };
	
	gettimeofday(&tv, NULL);
	srand(tv.tv_sec ^ tv.tv_usec);
	pattern = rand();
	printf("Pattern %08x\n", pattern);
}

void initChunk()
{
	int i;
	
	ptr = malloc(size);
	if (ptr == NULL) {
		fprintf(stderr, "Fail to allocate mem\n");
		fflush(stderr);
		return;
	}

	for (i = 0; i < size/4; i++)
		ptr[i] = pattern;
	
	printf("Initialized %d MB\n", size/(1024*1024));
	fflush(stdout);
}


void sig_handler()
{
	finish = 1;
}

void checkChunk()
{
	int i;
	int ok = 1;

	for (i = 0; i < size/4; i++)
		if (ptr[i] != pattern) {
			fprintf(stderr, "Memory corruption 0x%08x != 0x%08x\n", 
				ptr[i], pattern);
			fflush(stderr);
			ok = 0;
		}


	if (ok) {
		printf("Check ok\n");
		fflush(stdout);
	} else {
		/* In case of memory corruption sleep forever */
		while (1)
			sleep(1);
	}
}

int main(int argc, char *argv[])
{
	initArgs(argc, argv);
	initPattern();	
	initChunk();

	signal(SIGUSR1, sig_handler);
	signal(SIGINT, sig_handler);
	signal(SIGTERM, sig_handler);

	while (finish == 0)
		sleep(1);

	checkChunk();

	return 0;
}
